	clear all
	close all
	clc
	wsT = 0.556*pi; Amin = 60; N = 11;
	[G, Z, P, wcT, wsT, Amax, Amin] = CA_POLES_HB_Z(wsT, Amin, N);
	% Compute the adaptor coefficients 	
	[S1num, S1den, S2num, S2den] = SORT_LATTICE_POLES_HB_Z(P);
	[alfa_odd, alfa_even] = CASCADE_RICHARDS_SECTIONS(S1den, S2den);
	
	wT = linspace(0, pi, 1000); 
	[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wT);
	Att = MAG_2_ATT(0.5*(S2 - S1));
	
	figure(1)
	subplot('position', [0.1 0.4 0.88 0.5]);
	PLOT_ATT_Z(wT, Att, pi, 100), hold on
	AttC = MAG_2_ATT(0.5*(S2 + S1));
	plot(wT, AttC,'--', 'linewidth', 2)
	axis([0 pi 0 100]);	
	grid on,	hold off
	
	figure(2) 
	subplot('position', [0.1 0.4 0.88 0.5]);
	PLOT_ATT_Z(wT, Att, pi, 5*10^-7), hold on
	plot(wT, AttC,'--', 'linewidth', 2)
	axis([0 pi 0 5*10^-7]);	
	grid on,	hold off
	
	
	% check	
	S1den
	sqrt(alfa_odd)
	S2den
	sqrt(alfa_even)
	
	figure(3)
	PLOT_PZ_Z(Z, P)
	
	
	
